  
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:08:02 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_UTIL.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* canceling the lint warning: */
/*lint --e{718} */
/*lint --e{746} */
/*lint --e{826} */
/* disable Visual studio 2005 warning */
/*lint --e{553} */
/* disable warning for unknown define SST_DEBUG_MODE_ENABLED in case of rel mode */
#define _CRT_SECURE_NO_DEPRECATE

/************* Include Files ***********************************/
#include "SST_SEP_TST.h"
#include "NVS.h"
#include "msg_defs.h"
#include <stdio.h>
#include "SST_SEP_UTIL.h"
#include "SEP_ATP_UTIL_funcs.h"
/************************ Defines ******************************/
#define MW_ATP_MSG 		        10

/************************ Public Functions *********************/

/*****************************************************************************
 * Function Name:
 *  TST_CheckExpectedErrorReturn
 * 
 * Inputs:
 *  DxUint32_t TST_ErrorRet - The return value of the checked function
 *  DxUint32_t TST_ExpectedError - The expected return value of the checked function
 *  char     TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function
 * comparing the received result Vs the expected result 
 * If the operation had succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t TST_CheckExpectedErrorReturn(DxError_t TST_ErrorRet, 
                                          DxError_t TST_ExpectedError, 
                                          char         TST_FuncName[TST_FUNC_STRING_LEN],
                                          char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                          char         TST_MasterTestName[TST_FUNC_STRING_LEN])
{

    if (TST_ErrorRet != TST_ExpectedError)
    {
   
       /*ATP_LOG_TST_PRINT((SST_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName));           
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - Wrong Error returned!\n"));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - Error returned  --- %lX \n" ,TST_ErrorRet )); 
      
        ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!! TST_Error - instead of Error --- %lX \n" ,TST_ExpectedError ));           */

        printf("\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName);
        printf("!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName);           
        printf("!!!! TST_Error - %s failed\n",TST_FuncName);
        printf("!!!! TST_Error - Wrong Error returned!\n");
        printf("!!!! TST_Error - Error returned  --- %lX \n" ,TST_ErrorRet ); 
      
        printf("!!!! TST_Error - instead of Error --- %lX \n" ,TST_ExpectedError );           
       
                
    #if SST_TST_PRINT_TO_LOG_FILE

		DX_VOS_StrNCopy(TST_File_Location,sizeof(SST_TST_RESULT_LOG),SST_TST_RESULT_LOG);

        if (( Log_File_descriptor = fopen( TST_File_Location ,"a+")) == DX_NULL)   
        {
            ATP_LOG_TST_PRINT((SST_TST_MSG,"Can't open Log_File_descriptor \n"));
        }
        else
        {   
            fprintf(Log_File_descriptor,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");       
            fprintf(Log_File_descriptor,"!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName);
            fprintf(Log_File_descriptor,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName);         
            fprintf(Log_File_descriptor,"!!!! TST_Error - %s failed\n",TST_FuncName);
            fprintf(Log_File_descriptor,"!!!! TST_Error - Wrong Error returned!\n");
            fprintf(Log_File_descriptor,"!!!! TST_Error - Error returned  --- %lX \n" ,TST_ErrorRet); 
            fprintf(Log_File_descriptor,"!!!! TST_Error - instead of Error --- %lX \n" ,TST_ExpectedError) ;
            fprintf(Log_File_descriptor,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");             
            fclose(Log_File_descriptor);
        }
    #endif 
        return TESTFAIL;      
    }
    else
    {
        /*ATP_LOG_TST_PRINT((SST_TST_MSG,"TST_massage - "));
        ATP_LOG_TST_PRINT((SST_TST_MSG,"%s",TST_FuncName));
        ATP_LOG_TST_PRINT((SST_TST_MSG," Error returned correctly - Test pass \n"));                          
        */

        printf("\nTST_message - ");
        printf("%s",TST_FuncName);
        printf(" Error returned correctly - Test pass \n");                          
        return TESTPASS;        
    }   
	
}


/*****************************************************************************
 * Function Name:
 * SST_ATP_TST_ShowSSTVersion
 * Inputs:
 *  none
 *
 * Description:
 * This function prints the SST version and sub versions
 *
 ******************************************************************************/
void SST_ATP_TST_ShowSSTVersion(void)
{
	SSTVersion_t TST_SST_version;

	SST_VersionGet(&TST_SST_version);

    /*Printing the SST version and Engines */
    /*--------------------------------------*/
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n--------------[ SST VERSION ]-----------------------------------"));
    printf("\n SST VERSION  - %c%c%c-%c%d,%d,%d,%d",
                                         TST_SST_version.sst.componentName[0],
                                         TST_SST_version.sst.componentName[1],
                                         TST_SST_version.sst.componentName[2],
                                         TST_SST_version.sst.typeVer,
                                         TST_SST_version.sst.majorVer,
                                         TST_SST_version.sst.minorVer,
                                         TST_SST_version.sst.subVer,
                                         TST_SST_version.sst.internalVer);
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n-----------------------------------------------------------------"));
}





